//
//  BITimerWindow.h
//  BIViews
//
//  Created by Eric Hochmeister on 28/04/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <MCApplication/MCWindowController.h>

#define TimerWindowBottomEdgeHeight   12

@class BITimeSlip;
@class BIPlayPauseTexturedButton;
@class BIPunchOutTexturedButton;
@class BITimerTwiddleButton;
@class BITwiddleAddTexturedButton, BITwiddleCommentTexturedButton;
@class BIProject;
@class MCDurationPicker;
@class MCTableView, BITimerBackgroundView, BITimerTableView;

@interface BITimerWindow : MCWindowController {
	
	IBOutlet BITimerTableView* _timersTableView;

	IBOutlet NSTextField* _timeSlipsTitle;
    IBOutlet NSTextField* projectName;
	IBOutlet NSTextField* _timeSlipsTotal;
	IBOutlet BITimerTwiddleButton* _timersTwiddleButton;
	IBOutlet BITwiddleAddTexturedButton* _timersTwiddleAddButton;
	IBOutlet BITwiddleCommentTexturedButton* _timersTwiddleCommentButton;
	IBOutlet BIPlayPauseTexturedButton* _playPauseButton;
	IBOutlet BIPunchOutTexturedButton* _punchOutButton;
	IBOutlet BITimerBackgroundView* _bgView;

	IBOutlet MCDurationPicker*      _durationPicker;
	
	BIProject* _notLinkedProject;
	
	BOOL isActiveTimersTwiddleOpen;
	float variableHeight;
	
	IBOutlet NSArrayController* _timedSlipsController;

	float nameColumnDefaultWidth;
    
    BOOL postCurrentSlipNotif;
}
- (void)setupTimerWindow;

- (void)adjustWindowSizeForTableviewContentsWithAnimation:(BOOL)flag;
- (void)tableViewSelectionChanged;

- (void)setupSeparators;

- (void)setupNotLinkedProject;

- (void)configureFromUserDefaults;

- (BIProject *)notLinkedProject;
- (void)setNotLinkedProject:(BIProject *)aNotLinkedProject;

- (BITimeSlip*)createNotLinkedTimeSlip;

- (IBAction)startPauseTimers:(id)sender;
- (IBAction)punchOut:(id)sender;
- (void)notLinkedPunchOutDidEnd:(NSWindow*)sheet
					 returnCode:(int)returnCode
					contextInfo:(void*)contextInfo;


- (void)stopTimerForTimeSlip:(BITimeSlip*)aTimeSlip;

- (IBAction)twiddleActiveSlips:(id)sender;

	// accepts nil
- (BITimeSlip *)addNotLinkedTimeSlipAndStartWithName:(NSString *)aName;

- (IBAction)addNotLinkedTimeSlip:(id)sender;
- (IBAction)addNotLinkedTimeSlipAndStart:(id)sender;

- (IBAction)deleteNotLinkedTimeSlip:(id)sender;
- (IBAction)deleteSlips:(id)sender;

- (void)selectSlipGivenLastSelectedIndex:(NSInteger)anIndex;

#pragma mark notification methods

- (void)handleTimeSlipAdded:(NSNotification*)aNotif;
- (void)handleTimeSlipsAdded:(NSNotification*)aNotif;
- (void)handleTimeSlipsDeleted:(NSNotification*)aNotif;
- (void)handleAddNotLinkedTimer:(NSNotification*)aNotif;
- (void)handleTimedSlipCompleted:(NSNotification*)aNotif;
- (void)handleTimedSlipNotCompleted:(NSNotification*)aNotif;
- (void)handleCurrentTimerSlipChanged:(NSNotification*)aNotif;

- (IBAction)createTemplateFromSlip:(id)sender;
- (void)createSlipTemplateFromSlipSheetDidEnd:(NSWindow*)sheet
                                   returnCode:(int)returnCode
                                  contextInfo:(void*)contextInfo;

- (NSString*)determineProjectNameForSlips;

- (IBAction)edit:(id)sender;
- (IBAction)openSlip:(id)sender;

- (IBAction)editTimerEntryComment:(id)sender;

- (void)updateTimerWindow;

- (IBAction)relink:(id)sender;
- (IBAction)relinkSlip:(id)sender;
- (void)relinkSlipSheetDidEnd:(NSWindow*)sheet
                   returnCode:(int)returnCode
                  contextInfo:(void*)contextInfo;

- (IBAction)startStopTimer:(id)sender;
- (void)handleDurationFormatChanged:(NSNotification*)aNotif;

- (void)inlineEditSlip:(BITimeSlip*)aSlip;

- (BOOL)canBumpToRoundTime;
- (IBAction)bumpToRoundTime:(id)sender;

- (void)selectSlip:(id)aSlip;

@end
